%% function to convert a scalar index to a vector index, whose elements are the indices 
%% of the MFs. used in constructing the FLS
%% say scalar= 3 and numMFs=[2 2], then vector =[2 1].

function vector=scalarToVector(scalar,numMFs)

leng=length(numMFs);
vector=zeros(1,leng);
for i=1:leng
    level=prod(numMFs(i+1:leng));
    vector(i)=ceil(scalar/level);
    scalar=scalar-(vector(i)-1)*level;
end